/*
 * Decompiled with CFR 0.152.
 */
package itx.erp.sales.validator;

import itx.erp.sales.model.Article;
import jtbcore.exception.ContainerException;
import jtbcore.model.validator.BaseValidator;
import jtbcore.model.validator.ValidatorResult;
import jtbcore.util.StringUtil;

public class ArticleValidator
extends BaseValidator<Article> {
    public ArticleValidator() throws ContainerException {
        super.addValidator("articleId", null);
        super.addValidator("articleCode", null);
        super.addValidator("shortDescription", c -> {
            if (StringUtil.isEmpty(c.getShortDescription())) {
                return new ValidatorResult(false, "verplicht");
            }
            return null;
        });
        super.addValidator("longDescription", null);
        super.addValidator("note", null);
        super.addValidator("rentable", null);
        super.addValidator("overbookable", null);
        super.addValidator("maxBookable", c -> {
            if (c.getOverbookable().booleanValue() && (c.getMaxBookable() == null || c.getMaxBookable() != -1 && c.getMaxBookable() < 1)) {
                return new ValidatorResult(false, "ongeldige waarde");
            }
            return null;
        });
        super.addValidator("price", null);
        super.addValidator("vatId", null);
        super.addValidator("active", null);
    }
}

